﻿#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <cmath>
#include <iomanip>
#include <string>
#include <queue>
#include <deque>
#include <random>

using namespace std;
typedef long long ll;
typedef long double ld;
typedef unsigned long long ull;
void fastio() { ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0); }
#define all(a) a.begin(), a.end()
#define fout(a) cout << fixed << setprecision(a)

const long long INF = 2e9;
const ll MOD = 998244353;
const ld EPS = 1e-9;
mt19937_64 rng(time(0));

ll binpow(ll a, ll n) {
	ll ans = 1;
	ll k = a;
	while (n > 0) {
		if (n % 2) ans = (ans * k) % MOD;
		k = (k * k) % MOD;
		n /= 2;
	}
	return ans;
}

int main() {
	fastio();
	ll t;
	cin >> t;
	while (t--) {
		ll n, m;
		cin >> n >> m;
		vector<vector<ll>> dp(n + 1, vector<ll>(n + 1, 0)), sm(n+1, vector<ll>(n+1, 0));
		ll revm = binpow(m, MOD - 2) % MOD;
		sm[0][0] = 1;
		for (ll x = 1; x <= n; x++) {
			for (ll i = 0; i < x; i++) {
				sm[x][i] = sm[x - 1][i];
			}
			dp[x][x] = m;
			sm[x][x] = (sm[x - 1][x] + dp[x][x]) % MOD;
			for (ll i = x + 1; i <= n; i++) {
				dp[x][i] = (sm[x][i - x] * (m - 1) + sm[x-1][i-x] * (m - 1)) % MOD;
				for (ll j = 1; j + x < i; j++) {
					dp[x][i] = (dp[x][i] + sm[x - 1][j] * sm[x][i - x - j] % MOD * (m - 1) % MOD * (m - 1) % MOD * revm % MOD) % MOD;
				}
				sm[x][i] = (sm[x - 1][i] + dp[x][i]) % MOD;
			}
		}
		ll ans = 0;
		for (ll x = 1; x <= n; x++) {
			ans = (ans + x * dp[x][n]) % MOD;
		}
		cout << (ans * binpow(m, MOD - 1 - n)) % MOD << "\n";
	}
	return 0;
}